close all
clear all
clc

addpath('C:\Dropbox\bpea\forecasts');
addpath('C:\Dropbox\bpea\analysis-bpea\tables\var_bvar');
  
    
load flowsdata.mat

lfpr_forecast=csvread('lfpr_forecast.csv',1,0);
lfpr_actual=csvread('lfpr_actual.csv',1,0);
lfpr_errorstaff=[];
lfpr_errorSSmodel=[];

year=lfpr_actual(:,1);
month=lfpr_actual(:,2);

date=[year month];

enddate=length(date);
for i=1:enddate
    %forecast error from current Qter (to be forecasted) to Q+5
    lfpr_errorstaff(i,:)=(lfpr_actual(i,3:9)-lfpr_forecast(i,3:9))/100;
    YM=date(i,:);
    Y=YM(1);M=YM(2);
    
    % Since we don't have data for the current month, need to input previous
    % month data
    if M>1
        M=M-1;
    else
        M=12;
        Y=Y-1;
    end
    
    actualend=(Y-1967)*12 +M-5;
    
    jeu=n0(1:actualend,1);
    jei=n0(1:actualend,2);
    jiu=n0(1:actualend,3);
    jie=n0(1:actualend,4);
    jue=n0(1:actualend,5);
    jui=n0(1:actualend,6);
    
    Um=Um0(1:actualend);
    um=um0(1:actualend);
    vm=vm0(1:actualend);
    Em=Em0(1:actualend);
    lf=Em+Um;
    popm=popm0(1:actualend);
    Im=Im0(1:actualend);
    claims=claims0(1:actualend);
    
    POP=(popm);
    u=(um);
    V=(vm);U=(Um);E=(Em);I=(Im);
    
    
    % XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
    %use VAR to forecast
    % XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
   
    % 1) I forecast JS anf JF with a VAR
    Je=[];
    Je=[log(jeu) log(jue) log(jei) log(jie) log(jiu) log(jui) log(claims) log(vm) log(um)];
    Tf=42;
    
    % Use rolling window:
    % Only use the last 10 years of data to estimate the VAR ("rolling estimation window")
    Jet=Je(actualend-121:actualend-1,:);
    Jf=varf(Jet,3,Tf,length(Jet)+1);
    Jfor=[Je(1:actualend-1,:)' Jf']';
        
    jeufor=exp(Jfor(:,1));
    juefor=exp(Jfor(:,2));
    jeifor=exp(Jfor(:,3));
    jiefor=exp(Jfor(:,4));
    jiufor=exp(Jfor(:,5));
    juifor=exp(Jfor(:,6));
    
    sfor=jeifor.*jiufor+jiefor.*jeufor+jiufor.*jeufor;
    ffor=juifor.*jiefor+jiufor.*juefor+jiefor.*juefor;
    gfor=jeufor.*juifor+juefor.*jeifor+juifor.*jeifor;
    
    % Forecast population growth using the census projections
    POPfor=POP;
    while length(sfor)>length(POPfor)
        POPfor=[POPfor; POPfor(end)*(1+.0097/12)];
    end
    
    if length(sfor)<length(POPfor)
        POPfor=POPfor(1:length(sfor));
    end
    
    kfor=POPfor./(sfor+ffor+gfor);
    
    Ussfor=kfor.*sfor;
    Essfor=kfor.*ffor;
    Issfor=kfor.*gfor;
    
    Xfor=[];
    Xfor(:,1)=[U(1); E(1); I(1)];
    Ufor(1)=U(1);
    Efor(1)=E(1);
    Ifor(1)=I(1);
    
    for t=2:length(Ussfor)
        %get eigenvectors and eigenvalues of differential equation
        %ATTENTION: ordering is U E I
        A=[-juefor(t)-juifor(t) jeufor(t)  jiufor(t);  juefor(t) -jeufor(t)-jeifor(t) jiefor(t);juifor(t) jeifor(t)  -jiefor(t)-jiufor(t)];
        [P r]=eig(A);
        % Reorganize to get the two non-zeros evs first
        %P=[P(:,1) P(:,3) P(:,2)];
        r1=r(1,1);
        r2=r(2,2);
        r3=r(3,3);
        
        if t<=actualend %because you don't observe data for actualend
            soln=inv(P)*[U(t-1); E(t-1); I(t-1); ];
            c1=soln(1);c2=soln(2);c3=soln(3);
        else
            soln=inv(P)*[Ufor(t-1); Efor(t-1);Ifor(t-1); ];
            c1=(soln(1));c2=(soln(2));c3=soln(3);
        end
        
        Xfor(:,t)=P*[c1*exp(r1); c2*exp(r2); c3*exp(r3)];
        
        Ufor(1,t)=Xfor(1,t);Efor(1,t)=Xfor(2,t);Ifor(1,t)=Xfor(3,t);
    end
    
    ufor=(Ufor)./(Efor+Ufor);
    
    LFP=(E+U)./(E+U+I);
    LFPfor=(Efor+Ufor)./(Efor+Ufor+Ifor);
    
    % take Qterly avgs
    if (month(i)-1)/3==int8((month(i)-1)/3)
        
        lfpr_forSSmodel(i,:)=mq(LFPfor(actualend:actualend+Tf-2));
    else
        if (month(i))/3==int8((month(i))/3)
            
            lfpr_forSSmodel(i,:)=mq(LFPfor(actualend-2:actualend+Tf-2));
        else
            if (month(i)+1)/3==int8((month(i)+1)/3)
                lfpr_forSSmodel(i,:)=mq(LFPfor(actualend-1:actualend+Tf-2));
            end
        end
    end
    
    lfpr_errorSSmodel(i,:)=lfpr_actual(i,3:9)/100-lfpr_forSSmodel(i,1:7);
    
end

eStaff=100*lfpr_errorstaff(174:end,1:end-1);
eSS=100*lfpr_errorSSmodel(174:end,1:end-1);

disp('**********')
disp(horzcat('Relative MSE ofSSUR forecast:' ));
disp(horzcat('var SS model / var staff:' ));
disp(num2str(sum(eSS(1:end,:).^2,1)./sum(eStaff(1:end,:).^2,1)));

dssr=eStaff(1:end,:).^2-eSS.^2;

disp(horzcat([' ']));
Pval=[];
for i=1:size(eSS,2)
    [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
    Pval=[Pval pval];
end
disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
disp(num2str(Pval))

RMSE_SSUR3=((sum((eSS).^2,1))./length(eSS)).^.5
RMSE_Staff=((sum((eStaff).^2,1))./length(eStaff)).^.5
% XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX


% XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
% FORECAST COMBINATION FROM OLS
% XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
optwght=[];optwghtbd=[];varfin=[];comb0=[];comb=[];
optwght_MLE=[];optwghtbd_MLE=[];varfin_MLE=[];comb0_MLE=[];comb_MLE=[];
for ii=1:6
    %using OLS
    % vector of forecasts to be combined:
    forvec=[lfpr_forSSmodel(174:end,ii) lfpr_forecast(174:enddate,ii+2)/100 ones(length(lfpr_forecast(174:enddate,ii+2)),1)];
    [optwght(ii,:) bd_temp]= regress(lfpr_actual(174:enddate,ii+2)/100,forvec);
    optwghtbd(ii,:)=abs(bd_temp(:,1)-bd_temp(:,2))/4; % --> std errors
    comb0=[comb0  forvec*optwght(ii,:)'];
    comb=[comb comb0(:,ii)];
end

eCOMB=100*(lfpr_actual(174:enddate,3:3+5)/100-comb);
eBM=eStaff;

name=['  ESSU3   ' '  eGB     '  '  c     '];

disp('**********')
disp(horzcat('Optimal weights for forecast SSUR/Greenbook:' ));
disp(horzcat(num2str(name)));
disp(num2str(optwght))
disp(horzcat('Std errors optimal weights for forecast SSUR/Greenbook:' ));
disp(horzcat(num2str(name)));
disp(num2str(optwghtbd))

disp('**********')
disp(horzcat('relative MSE of optimal combined forecast SSUR/SSUR:' ));
disp(num2str(sum((eCOMB).^2,1)./sum((eBM).^2,1)))

dssr=(eCOMB).^2-(eBM).^2;
disp(horzcat([' ']));
Pval=[];
for i=1:size(eCOMB,2)
    [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
    Pval=[Pval pval];
end
disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
disp(num2str(Pval))

RMSE_COMB=((sum((eCOMB).^2,1))./length(eCOMB)).^.5


